@extends('layouts.admin')

@section('page-title')
    {{ __('Referral Program') }}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item">{{ __('Referral Program') }}</li>
@endsection


@push('script-page')
    <script>
        $('.cp_link').on('click', function() {
            var value = $(this).attr('data-link');
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val(value).select();
            document.execCommand("copy");
            $temp.remove();
            show_toastr('success', '{{ __('Link Copy on Clipboard') }}')
        });

        $('.tab-link').on('click', function() {
            var tabId = $(this).data('tab');
            $('.tab-content').addClass('d-none');
            $('#' + tabId).removeClass('d-none');

            $('.tab-link').removeClass('active');
            $(this).addClass('active');
        });
    </script>
@endpush

@php
    $settings = Utility::getAdminPaymentSetting();
    $currency = isset($settings['currency_symbol']) ? $settings['currency_symbol'] : '$';
    $companySetting = Utility::settingsById(\Auth::user()->creatorId());
    $companyName = $companySetting['company_name'] ? $companySetting['company_name'] : \Auth::user()->name;
@endphp


@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="row">
                <div class="col-xl-3">
                    <div class="card sticky-top" style="top:30px">
                        <div class="list-group list-group-flush" id="useradd-sidenav">
                            <a href="#" class="list-group-item list-group-item-action border-0 tab-link active"
                                data-tab="guideline">{{ __('GuideLine') }}
                                <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                            </a>
                            <a href="#" class="list-group-item list-group-item-action border-0 tab-link"
                                data-tab="referral-transaction">{{ __('Referral Transaction') }}
                                <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                            </a>
                            <a href="#" class="list-group-item list-group-item-action border-0 tab-link"
                                data-tab="payout">{{ __('Payout') }}
                                <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-xl-9">
                    {{--  Start for all settings tab --}}

                    <!--Site Settings-->
                    <div id="guideline" class="card tab-content">
                        <div class="card-header">
                            <h5>{{ __('GuideLine') }}</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-5 mb-3 mb-md-0">
                                    <div class = "border rounded p-3 mb-0">
                                        <h4>{{ __('Refer ') . $companyName .  __(' and earn ') . (isset($setting) ? $setting->minimum_threshold_amount : '') . __('% per paid signup!') }}</h4>
                                        {!! isset($setting) ? $setting->guideline : '' !!}
                                    </div>
                                </div>
                                <div class="col-md-7">
                                    <div class="form-group border rounded p-3 mb-0 d-flex flex-column justify-content-center h-100">
                                    <h4>{{ __('Share Your Link') }}</h4>
                                    <div class="d-flex justify-content-between">
                                        <a href="#!" class="btn btn-sm btn-primary text-break w-100 cp_link d-flex flex-wrap align-items-center justify-content-center gap-2"
                                            data-link="{{ route('register', ['ref_id' => \Auth::user()->referral_code]) }}"
                                            data-bs-toggle="tooltip" data-bs-placement="top" title=""
                                            data-bs-original-title="Click to copy business link">
                                            {{ route('register', ['ref' => \Auth::user()->referral_code]) }}
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-copy ms-1">
                                                <rect x="9" y="9" width="13" height="13" rx="2"
                                                    ry="2"></rect>
                                                <path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                                </div>
                                @if(isset($setting) && $setting->is_enable == 0 || !isset($setting))
                                        <h6 class="text-end text-danger text-md mt-2">{{ __('Note : super admin has disabled the referral program.') }}</h6>
                                    @endif
                            </div>
                        </div>

                    </div>

                    <div id="referral-transaction" class="card tab-content d-none">
                        <div class="card-header">
                            <h5>{{ __('Referral Transaction') }}</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table datatable">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>{{ __('Company Name') }}</th>
                                            <th>{{ __('Plan Name') }}</th>
                                            <th>{{ __('Plan Price') }}</th>
                                            <th>{{ __('Commission (%)') }}</th>
                                            <th>{{ __('Commission Amount') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($transactions as $key => $transaction)
                                            <tr>
                                                <td> {{ ++$key }} </td>
                                                <td>{{ !empty($transaction->getUser) ? $transaction->getUser->name : '-' }}
                                                </td>
                                                <td>{{ !empty($transaction->getPlan) ? $transaction->getPlan->name : '-' }}
                                                </td>
                                                <td>{{ $currency . $transaction->plan_price }}</td>
                                                <td>{{ $transaction->commission }}</td>
                                                <td>{{ $currency . ($transaction->plan_price * $transaction->commission) / 100 }}
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div id="payout" class="tab-content d-none">
                        <div class="card">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-6">
                                        <h5 class="">{{ __('PayOut') }}</h5>
                                    </div>
                                    <div class="col-6 text-end">
                                        @if (\Auth::user()->commission_amount > $paidAmount)
                                            @if ($paymentRequest == null)
                                                <a href="#"
                                                    data-url = "{{ route('request.amount.sent', [\Illuminate\Support\Facades\Crypt::encrypt(\Auth::user()->id)]) }}"
                                                    data-ajax-popup="true" class="btn btn-primary btn-sm"
                                                    data-title="{{ __('Send Request') }}" data-bs-toggle="tooltip"
                                                    title="{{ __('Send Request') }}">
                                                    <span class="btn-inner--icon"><i
                                                            class="ti ti-corner-up-right"></i></span>
                                                </a>
                                            @else
                                                <a href="{{ route('request.amount.cancel', \Auth::user()->id) }}"
                                                    class="btn btn-danger btn-sm" data-title="{{ __('Cancle Request') }}"
                                                    data-bs-toggle="tooltip" title="{{ __('Cancle Request') }}">
                                                    <span class="btn-inner--icon"><i class="ti ti-x"></i></span>
                                                </a>
                                            @endif
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row align-items-center justify-content-between gy-3">
                                    <div class="col-md-6 col-12 payout-card">
                                        <div class="payout-card-inner d-flex align-items-start gap-3">
                                            <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80"
                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                                                    fill="#FF3A6E"></path>
                                            </svg>
                                            <div class="payout-icon">
                                                <div class="icon-inner">
                                                    <svg width="24" height="24" viewBox="0 0 24 24"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <g clip-path="url(#clip0_44_514)">
                                                            <path
                                                                d="M17.2191 4.41309C17.219 4.35677 17.2355 4.30168 17.2667 4.25477C17.2979 4.20786 17.3423 4.17125 17.3942 4.14957C17.4462 4.12789 17.5035 4.12211 17.5587 4.13296C17.614 4.14381 17.6648 4.17081 17.7047 4.21054C17.7447 4.25026 17.7719 4.30094 17.783 4.35615C17.7941 4.41136 17.7886 4.46863 17.7672 4.52072C17.7458 4.5728 17.7094 4.61737 17.6627 4.64878C17.6159 4.68018 17.5609 4.69702 17.5046 4.69716C17.4291 4.69727 17.3566 4.66742 17.3031 4.61417C17.2496 4.56091 17.2194 4.4886 17.2191 4.41309ZM19.491 6.68363C19.491 6.73982 19.5076 6.79476 19.5388 6.8415C19.57 6.88823 19.6144 6.92466 19.6663 6.94618C19.7182 6.96769 19.7754 6.97333 19.8305 6.96238C19.8856 6.95143 19.9362 6.92438 19.976 6.88465C20.0157 6.84492 20.0428 6.7943 20.0537 6.73918C20.0647 6.68407 20.0591 6.62694 20.0376 6.57502C20.0161 6.5231 19.9797 6.47872 19.933 6.4475C19.8862 6.41628 19.8313 6.39961 19.7751 6.39961C19.6999 6.39988 19.6278 6.42989 19.5745 6.48309C19.5213 6.53629 19.4913 6.60838 19.491 6.68363ZM21.7065 17.0652C21.672 16.9614 21.617 16.8655 21.5449 16.7833C21.4728 16.701 21.3849 16.6341 21.2865 16.5863C21.1933 16.5403 21.0918 16.5134 20.988 16.5072C20.8842 16.501 20.7802 16.5157 20.6822 16.5503L20.1925 16.7237C20.1591 16.8679 20.1203 17.0081 20.0746 17.1429C19.975 17.4407 19.8377 17.7246 19.6663 17.9877L21.7486 17.2693C21.7432 17.1998 21.7291 17.1312 21.7065 17.0652ZM0.375977 23.0882H2.74101V15.0098H0.375977V23.0882ZM13.0711 5.83097C13.0289 5.67047 13.0231 5.50257 13.0541 5.33954C13.0852 5.17652 13.1523 5.02251 13.2506 4.88878L13.8209 4.10344C13.8686 4.04115 13.8934 3.96433 13.8912 3.88589V2.91361C13.8914 2.87108 13.894 2.8286 13.8988 2.78635C13.7384 2.80948 13.5761 2.81576 13.4144 2.8051C12.8219 2.84686 12.3109 2.63841 11.8588 2.4541C11.0651 2.13042 10.5259 1.91035 9.69787 2.86791L11.0952 5.83106L13.0711 5.83097ZM10.7577 15.4972C9.75032 14.6799 8.63127 14.2776 7.33902 14.2665C7.58089 12.8461 8.13064 11.4959 8.9497 10.3106C9.86643 9.00774 10.9606 8.26055 11.9516 8.26055H13.8941C13.9086 8.48382 13.99 8.69755 14.1277 8.87394C14.2654 9.05033 14.4529 9.18123 14.666 9.24961L15.5894 9.54984C15.6648 9.5725 15.7303 9.61996 15.7754 9.68452L16.3469 10.472C16.4488 10.6151 16.5834 10.7319 16.7395 10.8126C16.8956 10.8934 17.0687 10.9357 17.2444 10.936C17.3653 10.9358 17.4854 10.9165 17.6002 10.8788L18.1386 10.7046C19.3978 12.7157 19.9136 15.281 19.3642 16.9028C19.1216 17.6192 18.6879 18.1303 18.0736 18.4274C17.9167 18.1659 17.6947 17.9494 17.4294 17.7991C17.164 17.6488 16.8642 17.5697 16.5592 17.5695H14.8584C13.8165 17.5695 12.9165 17.2502 12.1071 16.5933L10.7577 15.4972ZM14.2496 14.8332C14.2496 15.2164 13.8749 15.5282 13.4142 15.5282C12.9536 15.5282 12.5788 15.2164 12.5788 14.8332C12.5788 14.7337 12.5393 14.6383 12.469 14.568C12.3986 14.4977 12.3033 14.4582 12.2038 14.4582C12.1043 14.4582 12.009 14.4977 11.9386 14.568C11.8683 14.6383 11.8288 14.7337 11.8288 14.8332C11.8288 15.5122 12.3455 16.083 13.0392 16.237V16.561C13.0392 16.6605 13.0787 16.7559 13.149 16.8262C13.2194 16.8965 13.3148 16.936 13.4142 16.936C13.5137 16.936 13.609 16.8965 13.6794 16.8262C13.7497 16.7559 13.7892 16.6605 13.7892 16.561V16.2372C14.483 16.0832 14.9996 15.5123 14.9996 14.8333C14.9996 13.715 14.0923 13.524 13.4918 13.3976C12.8155 13.2553 12.5788 13.1636 12.5788 12.6945C12.5788 12.312 12.9538 12.0008 13.4142 12.0008C13.8746 12.0008 14.2496 12.3119 14.2496 12.6945C14.2496 12.794 14.2891 12.8893 14.3594 12.9597C14.4297 13.03 14.5251 13.0695 14.6246 13.0695C14.724 13.0695 14.8194 13.03 14.8897 12.9597C14.9601 12.8893 14.9996 12.794 14.9996 12.6945C14.9996 12.0161 14.483 11.4458 13.7892 11.292V10.9682C13.7892 10.8687 13.7497 10.7733 13.6794 10.703C13.609 10.6327 13.5137 10.5932 13.4142 10.5932C13.3148 10.5932 13.2194 10.6327 13.149 10.703C13.0787 10.7733 13.0392 10.8687 13.0392 10.9682V11.292C12.3455 11.4458 11.8288 12.0161 11.8288 12.6945C11.8288 13.8139 12.7366 14.005 13.3373 14.1315C14.0131 14.2735 14.2496 14.3651 14.2496 14.8332ZM22.4374 17.8253L18.3237 19.2445C18.3252 19.2748 18.326 19.3053 18.326 19.3359C18.3255 19.8044 18.1392 20.2534 17.808 20.5847C17.4767 20.9159 17.0277 21.1022 16.5592 21.1028H10.6547C10.5553 21.1028 10.4599 21.0632 10.3896 20.9929C10.3192 20.9226 10.2797 20.8272 10.2797 20.7278C10.2797 20.6283 10.3192 20.5329 10.3896 20.4626C10.4599 20.3923 10.5553 20.3528 10.6547 20.3528H16.5592C16.8277 20.3509 17.0846 20.243 17.2738 20.0525C17.463 19.862 17.5692 19.6044 17.5692 19.336C17.5692 19.0675 17.463 18.8099 17.2738 18.6194C17.0846 18.4289 16.8277 18.321 16.5592 18.3192H14.8584C13.6375 18.3192 12.5829 17.945 11.6345 17.1752L10.2851 16.0795C9.40251 15.3635 8.4209 15.0155 7.28432 15.0155C6.38671 15.0155 5.96648 15.2293 5.56007 15.4361C5.19416 15.6223 4.81584 15.8148 4.19601 15.8148H3.49101V22.2845H3.68432C4.15953 22.2801 4.63028 22.3763 5.06568 22.5667L5.57845 22.787C5.92032 22.9388 6.29094 23.0149 6.66496 23.0103C6.90801 23.0103 7.27138 23.0162 7.69213 23.0231C9.42009 23.0512 12.6361 23.1037 13.4522 22.8224L23.0217 19.5201C23.2465 19.4426 23.4312 19.279 23.5353 19.0653C23.6395 18.8516 23.6544 18.6053 23.5769 18.3805C23.4995 18.1558 23.3359 17.971 23.1221 17.8669C22.9084 17.7628 22.6621 17.7478 22.4374 17.8253V17.8253ZM13.8565 5.33077L14.4282 4.5436C14.5688 4.35343 14.6435 4.12255 14.641 3.88603V2.91361C14.6395 2.83476 14.6637 2.75756 14.7101 2.69376C14.7565 2.62996 14.8224 2.58303 14.8979 2.56013L15.8227 2.25947C16.0485 2.18864 16.2449 2.04586 16.382 1.85292L16.9529 1.068C16.9979 1.00306 17.0629 0.954595 17.138 0.92998C17.213 0.905365 17.2941 0.905948 17.3688 0.931642L18.2922 1.23164C18.5171 1.30702 18.7604 1.30718 18.9854 1.23211L19.9096 0.931595C19.9842 0.905677 20.0653 0.904963 20.1403 0.929564C20.2153 0.954164 20.2802 1.00272 20.325 1.06777L20.8956 1.85217C21.0332 2.04591 21.2306 2.18903 21.4575 2.25947L22.3801 2.55989C22.4557 2.58276 22.5216 2.62967 22.5681 2.69348C22.6145 2.7573 22.6388 2.83453 22.6372 2.91342V3.88603C22.6352 4.12298 22.7106 4.35413 22.8519 4.5443L23.4233 5.33119C23.4707 5.39397 23.4963 5.47049 23.4963 5.54916C23.4963 5.62783 23.4707 5.70435 23.4233 5.76713L22.8514 6.55317C22.7111 6.74416 22.6359 6.97527 22.6371 7.21228V8.18316C22.639 8.26211 22.6148 8.33947 22.5683 8.40333C22.5219 8.4672 22.4558 8.51404 22.3801 8.53664L21.4579 8.83697C21.2317 8.90879 21.0346 9.05154 20.8959 9.24408L20.3244 10.0313C20.2793 10.096 20.2143 10.1441 20.1392 10.1683C20.0642 10.1924 19.9833 10.1913 19.9089 10.165L18.9861 9.86634C18.7611 9.79119 18.5178 9.79119 18.2929 9.86634L17.3686 10.1655C17.2942 10.1913 17.2134 10.1922 17.1384 10.1679C17.0635 10.1436 16.9985 10.0956 16.9534 10.031L16.3815 9.24352C16.2431 9.05189 16.047 8.90961 15.8219 8.83753L14.8966 8.53603C14.8212 8.51325 14.7554 8.46639 14.7093 8.40263C14.6631 8.33886 14.6391 8.26171 14.641 8.18302V7.21228C14.6437 6.97491 14.5687 6.74317 14.4276 6.55233L13.8561 5.76689C13.8083 5.70425 13.7824 5.62759 13.7825 5.54877C13.7826 5.46994 13.8086 5.39333 13.8565 5.33077ZM19.7751 5.64952C19.5704 5.64938 19.3702 5.70997 19.1999 5.82362C19.0297 5.93727 18.8969 6.09887 18.8185 6.28798C18.7401 6.47709 18.7196 6.68521 18.7595 6.886C18.7994 7.08679 18.898 7.27123 19.0427 7.41599C19.1875 7.56074 19.3719 7.65931 19.5727 7.6992C19.7735 7.7391 19.9816 7.71855 20.1707 7.64013C20.3598 7.56172 20.5214 7.42897 20.6351 7.25869C20.7487 7.08841 20.8093 6.88825 20.8092 6.68353C20.8088 6.40941 20.6997 6.14661 20.5059 5.95279C20.312 5.75896 20.0492 5.64993 19.7751 5.64961V5.64952ZM17.0432 7.09416C17.0138 7.13387 16.9924 7.17901 16.9805 7.227C16.9685 7.27498 16.9662 7.32485 16.9736 7.37374C16.981 7.42263 16.998 7.46958 17.0236 7.51187C17.0492 7.55417 17.083 7.59098 17.1229 7.62019C17.1628 7.6494 17.2081 7.67043 17.2561 7.68207C17.3042 7.69371 17.3541 7.69573 17.4029 7.68801C17.4517 7.68029 17.4986 7.663 17.5407 7.63711C17.5828 7.61122 17.6194 7.57726 17.6484 7.53717L20.235 4.00383C20.2937 3.92357 20.3182 3.82327 20.303 3.72498C20.2878 3.62669 20.2342 3.53847 20.1539 3.47972C20.0736 3.42097 19.9733 3.39651 19.875 3.41172C19.7768 3.42693 19.6885 3.48056 19.6298 3.56081L17.0432 7.09416ZM16.4691 4.41291C16.469 4.61757 16.5295 4.81767 16.6431 4.98792C16.7567 5.15817 16.9182 5.29092 17.1072 5.36937C17.2962 5.44783 17.5043 5.46847 17.705 5.42868C17.9058 5.3889 18.0902 5.29048 18.235 5.14586C18.3799 5.00125 18.4785 4.81694 18.5186 4.61624C18.5587 4.41554 18.5383 4.20746 18.4601 4.01833C18.382 3.8292 18.2494 3.66749 18.0793 3.55368C17.9093 3.43986 17.7092 3.37903 17.5046 3.37889C17.2302 3.37902 16.9671 3.48798 16.773 3.68186C16.5788 3.87575 16.4696 4.13873 16.4691 4.41309V4.41291ZM13.5209 6.58078H10.8572C10.7958 6.58017 10.7349 6.59173 10.6779 6.61481C10.621 6.63789 10.5692 6.67203 10.5255 6.71525C10.4819 6.75847 10.4472 6.80992 10.4236 6.86662C10.3999 6.92332 10.3877 6.98414 10.3877 7.04557C10.3877 7.107 10.3999 7.16783 10.4236 7.22452C10.4472 7.28122 10.4819 7.33267 10.5255 7.37589C10.5692 7.41911 10.621 7.45325 10.6779 7.47633C10.7349 7.49941 10.7958 7.51098 10.8572 7.51036H13.8909V7.21228C13.8929 7.13319 13.868 7.05576 13.8203 6.99267L13.5209 6.58078Z"
                                                                fill="white" />
                                                        </g>
                                                        <defs>
                                                            <clipPath id="clip0_44_514">
                                                                <rect width="24" height="24" fill="white"
                                                                    transform="translate(0.000976562)" />
                                                            </clipPath>
                                                        </defs>
                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="payout-content flex-1">
                                                <span class="text-sm d-block mb-1">{{ __('Total') }}</span>
                                                <h2 class="h5 mb-0">{{ __('Commission Amount') }}</h2>
                                            </div>
                                            <h3 class="h4 mb-0">{{ $currency . \Auth::user()->commission_amount }}</h3>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-12 payout-card">
                                        <div class="payout-card-inner d-flex align-items-start gap-3">
                                            <svg class="bottom-svg" width="135" height="80" viewBox="0 0 135 80"
                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M74.7692 35C27.8769 35 5.38462 65 0 80H135.692V0C134.923 11.6667 121.662 35 74.7692 35Z"
                                                    fill="#FF3A6E"></path>
                                            </svg>
                                            <div class="payout-icon">
                                                <div class="icon-inner">
                                                    <svg width="24" height="24" viewBox="0 0 24 24"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M21.0314 3.18164H4.00171C3.172 3.18164 2.5 3.85364 2.5 4.67993V9.11307C2.5 9.93935 3.172 10.6114 4.00171 10.6114H6.15143V8.22507H5.71943C4.98914 8.22507 4.39257 7.6285 4.39257 6.89821C4.39257 6.54507 4.52971 6.2125 4.78343 5.96221C5.03371 5.71193 5.36629 5.57136 5.71943 5.57136H6.32286H18.7069H19.3069C20.0406 5.57136 20.6371 6.16793 20.6371 6.89821C20.6371 7.25136 20.5 7.58393 20.2463 7.83421C19.996 8.0845 19.66 8.22507 19.3069 8.22507H18.8783V10.6114H21.0349C21.8611 10.6114 22.5331 9.93935 22.5331 9.11307V4.67993C22.5331 3.85364 21.8577 3.18164 21.0314 3.18164Z"
                                                            fill="white" />
                                                        <path
                                                            d="M15.3095 8.5747C15.3815 8.5027 15.4706 8.36899 15.4706 8.18385C15.4706 7.8787 15.2203 7.62842 14.9152 7.62842H10.3689C10.1803 7.62842 10.05 7.71756 9.97462 7.79299C9.90262 7.86842 9.81348 7.9987 9.81348 8.18385C9.81348 8.48899 10.0638 8.73927 10.3689 8.73927H14.9152C15.1003 8.73927 15.2306 8.65013 15.3095 8.5747Z"
                                                            fill="white" />
                                                        <path
                                                            d="M5.02335 6.20231C4.83821 6.38745 4.73535 6.63431 4.73535 6.89831C4.73535 7.44002 5.17764 7.88231 5.71935 7.88231H6.15135V5.91431H5.71935C5.45535 5.91431 5.20849 6.01716 5.02335 6.20231Z"
                                                            fill="white" />
                                                        <path
                                                            d="M4.00197 2.83879H21.0351C21.1174 2.83879 21.1963 2.8525 21.2751 2.86279C21.0077 2.43079 20.5345 2.15308 20.0065 2.15308H2.97339C2.14368 2.15308 1.47168 2.82508 1.47168 3.65136V8.0845C1.47168 8.60908 1.74939 9.08222 2.18139 9.34965C2.17111 9.27079 2.15739 9.19193 2.15739 9.11308V4.67993C2.15397 3.66508 2.98368 2.83879 4.00197 2.83879Z"
                                                            fill="white" />
                                                        <path
                                                            d="M19.3036 7.88231C19.5676 7.88231 19.8144 7.77945 20.003 7.59431C20.1916 7.40916 20.291 7.16231 20.291 6.89831C20.291 6.35659 19.8487 5.91431 19.3036 5.91431H18.875V7.88231H19.3036Z"
                                                            fill="white" />
                                                        <path
                                                            d="M18.0592 21.5932C18.1655 21.6412 18.2855 21.6309 18.3815 21.5657C18.4775 21.5006 18.5358 21.3977 18.5358 21.2846V5.91431H6.49121V8.05374V10.7829V21.2846C6.49121 21.4012 6.54607 21.5075 6.6455 21.5692C6.7415 21.6309 6.8615 21.6412 6.96778 21.5932L7.59521 21.3154C7.77007 21.2366 7.97235 21.2366 8.14721 21.3154L9.2855 21.8194C9.37121 21.8572 9.47064 21.8572 9.55635 21.8194L10.6946 21.3154C10.7804 21.2777 10.8764 21.2572 10.9689 21.2572C11.0615 21.2572 11.1575 21.2777 11.2466 21.3154L12.3815 21.8194C12.4672 21.8572 12.5666 21.8572 12.6524 21.8194L13.7872 21.3154C13.9621 21.2366 14.1644 21.2366 14.3392 21.3154L15.4775 21.8194C15.5632 21.8572 15.6626 21.8572 15.7484 21.8194L16.8832 21.3154C17.0581 21.2366 17.2604 21.2366 17.4352 21.3154L18.0592 21.5932ZM9.35407 16.3097H8.0375C7.9415 16.3097 7.86607 16.2343 7.86607 16.1383C7.86607 16.0423 7.9415 15.9669 8.0375 15.9669H9.35407C9.45007 15.9669 9.5255 16.0423 9.5255 16.1383C9.5255 16.2343 9.44664 16.3097 9.35407 16.3097ZM9.35407 14.4412H8.0375C7.9415 14.4412 7.86607 14.3657 7.86607 14.2697C7.86607 14.1737 7.9415 14.0983 8.0375 14.0983H9.35407C9.45007 14.0983 9.5255 14.1737 9.5255 14.2697C9.5255 14.3657 9.44664 14.4412 9.35407 14.4412ZM9.35407 12.576H8.0375C7.9415 12.576 7.86607 12.5006 7.86607 12.4046C7.86607 12.3086 7.9415 12.2332 8.0375 12.2332H9.35407C9.45007 12.2332 9.5255 12.3086 9.5255 12.4046C9.5255 12.5006 9.44664 12.576 9.35407 12.576ZM9.35407 10.7109H8.0375C7.9415 10.7109 7.86607 10.6354 7.86607 10.5394C7.86607 10.4434 7.9415 10.368 8.0375 10.368H9.35407C9.45007 10.368 9.5255 10.4434 9.5255 10.5394C9.5255 10.6354 9.44664 10.7109 9.35407 10.7109ZM10.3689 9.08231C9.87521 9.08231 9.47064 8.67774 9.47064 8.18402C9.47064 7.94745 9.56321 7.72459 9.73121 7.54974C9.90607 7.37831 10.1324 7.28574 10.3689 7.28574H14.9152C15.4089 7.28574 15.8135 7.69031 15.8135 8.18402C15.8135 8.42059 15.7209 8.64345 15.5529 8.81831C15.3781 8.98974 15.1518 9.08231 14.9152 9.08231H10.3689ZM16.9895 19.0526H13.1529C13.0569 19.0526 12.9815 18.9772 12.9815 18.8812C12.9815 18.7852 13.0569 18.7097 13.1529 18.7097H16.9895C17.0855 18.7097 17.1609 18.7852 17.1609 18.8812C17.1609 18.9772 17.0855 19.0526 16.9895 19.0526ZM16.9895 16.3097H11.0409C10.9449 16.3097 10.8695 16.2343 10.8695 16.1383C10.8695 16.0423 10.9449 15.9669 11.0409 15.9669H16.9929C17.0889 15.9669 17.1644 16.0423 17.1644 16.1383C17.1609 16.2343 17.0855 16.3097 16.9895 16.3097ZM16.9895 14.4412H11.0409C10.9449 14.4412 10.8695 14.3657 10.8695 14.2697C10.8695 14.1737 10.9449 14.0983 11.0409 14.0983H16.9929C17.0889 14.0983 17.1644 14.1737 17.1644 14.2697C17.1609 14.3657 17.0855 14.4412 16.9895 14.4412ZM16.9895 12.576H11.0409C10.9449 12.576 10.8695 12.5006 10.8695 12.4046C10.8695 12.3086 10.9449 12.2332 11.0409 12.2332H16.9929C17.0889 12.2332 17.1644 12.3086 17.1644 12.4046C17.1644 12.5006 17.0855 12.576 16.9895 12.576ZM16.9895 10.7109H11.0409C10.9449 10.7109 10.8695 10.6354 10.8695 10.5394C10.8695 10.4434 10.9449 10.368 11.0409 10.368H16.9929C17.0889 10.368 17.1644 10.4434 17.1644 10.5394C17.1644 10.6354 17.0855 10.7109 16.9895 10.7109Z"
                                                            fill="white" />
                                                    </svg>
                                                </div>
                                            </div>
                                            <div class="payout-content flex-1">
                                                <span class="text-sm d-block mb-1">{{ __('Paid') }}</span>
                                                <h2 class="h5 mb-0">{{ __('Paid Amount') }}</h2>
                                            </div>
                                            <h3 class="h4 mb-0">{{ $currency . $paidAmount }}</h3>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>




                        <div class="card">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-6">
                                        <h5 class="">{{ __('Payout History') }}</h5>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body table-border-style">
                                <div class="table-responsive">
                                    <table class="table datatable">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{ __('Company Name') }}</th>
                                                <th>{{ __('Requested Date') }}</th>
                                                <th>{{ __('Status') }}</th>
                                                <th>{{ __('Requested Amount') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($transactionsOrder as $key => $transaction)
                                                <tr>
                                                    <td>{{ ++$key }}</td>
                                                    <td>{{ \Auth::user()->name }}</td>
                                                    <td>{{ $transaction->date }}</td>
                                                    <td>
                                                        @if ($transaction->status == 0)
                                                            <span
                                                                class="status_badge badge bg-danger p-2 px-3 rounded">{{ __(\App\Models\TransactionOrder::$status[$transaction->status]) }}</span>
                                                        @elseif($transaction->status == 1)
                                                            <span
                                                                class="status_badge badge bg-warning p-2 px-3 rounded">{{ __(\App\Models\TransactionOrder::$status[$transaction->status]) }}</span>
                                                        @elseif($transaction->status == 2)
                                                            <span
                                                                class="status_badge badge bg-primary p-2 px-3 rounded">{{ __(\App\Models\TransactionOrder::$status[$transaction->status]) }}</span>
                                                        @endif
                                                    </td>
                                                    <td>{{ $currency . $transaction->req_amount }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
